#!/bin/sh
# ZAP-timer
# Wayne?

PID_FILE=/var/run/ZAP-timer.pid
if [ -e $PID_FILE ]; then
 rm -rf $PID_FILE >/dev/null 2>&1
 exit
fi
touch $PID_FILE

# test parameter
[ "$1" -ge 0 2>/dev/null ] && ZAP_MIN=$1 || ZAP_MIN=7

# Get nhttpd's options
CTRL_FILE="/var/tuxbox/config/nhttpd.conf"
CTRL_PORT="$(cat $CTRL_FILE 2>/dev/null | sed -n 's/^WebsiteMain.port= *\(.*\) */:\1/p')"
CTRL_USER="$(cat $CTRL_FILE 2>/dev/null | sed -n 's/^mod_auth.username= *\(.*\) */\1/p')"
CTRL_PASS="$(cat $CTRL_FILE 2>/dev/null | sed -n 's/^mod_auth.password= *\(.*\) */\1/p')"
[ -n "$CTRL_USER" -a -n "$CTRL_PASS" ] && CTRL_AUTH="${CTRL_USER}:${CTRL_PASS}@"
CTRL_ZAP="http://${CTRL_AUTH}127.0.0.1${CTRL_PORT}/control/"

# Show on TV
msg() {
 [ $# -lt 2 ] && return 1
 [ "$1" == "popup" -o "$1" == "nmsg" ] && msg_mode="$1"
 [ -z "$msg_mode" ] && return 1
 shift
 echo WGET "${CTRL_ZAP}message?${msg_mode}=$(echo $*|sed 's/ /%20/g')"
 wget -q -O - "${CTRL_ZAP}message?${msg_mode}=$(echo $*|sed 's/ /%20/g')" >/dev/null 2>&1
}
      
# Log to VFD & Console
log() {
 echo "$*"
# fp_control --settext "$*" >/dev/null
# oled -tc "$*"
 oled -tu "$1" -tc "$2" -td "$3"
}

#initial
msg popup "ZAP-timer wartet ${ZAP_MIN} Minute(n)%0A%0AZum abbrechen Plugin nochmals starten"
log "ZAP-timer" "${ZAP_MIN} min"
#CHAN_CUR="$(wget -q ${CTRL_ZAP}zapto -O - 2>&1)"
CHAN_CUR="$(wget -q ${CTRL_ZAP}zapto -O -)"

#mainloop
while [ "$ZAP_MIN" -gt 0 ]; do
 log "ZAP-timer" "${ZAP_MIN} min"
 _counter=0
 while [ "$_counter" -lt 15 ]; do
  sleep 4
  let _counter++
  [ -e $PID_FILE ] || break
 done
 [ -e $PID_FILE ] || break
 let ZAP_MIN--
done

#final
[ -n "$CHAN_CUR" ] && wget -q ${CTRL_ZAP}zapto?$CHAN_CUR -O - >/dev/null 2>&1
sleep 2
if [ -e $PID_FILE ]; then
 rm -rf $PID_FILE >/dev/null 2>&1
 msg popup "ZAP-timer erfolgeich"
 log "ZAP-timer" "fertig"
else
 msg popup "ZAP-timer abgebrochen"
 log "ZAP-timer" "ende"
fi
